<?php 

// Авторизация по уникальному коду, переданному в параметре 

$user_code = $_GET['user_code'] ?? null; 
if (!$user_code) { die('User code is required'); } 

require_once '../inc/db.php'; 
$db = new DB(); 
$pdo = $db->getConnection(); 
$stmt = $pdo->prepare("SELECT * FROM users WHERE unique_code = ?"); 
$stmt->execute([$user_code]); 
$user = $stmt->fetch(); 

if (!$user) { die('Invalid user code'); } 
$user_id = $user['id']; 
$user_name = $user['name']; 

// Получаем чаты пользователя (как в chat.php) 
$stmt = $pdo->prepare(" SELECT c.id, c.unique_code, 'chat' as type, NULL as name FROM chats c JOIN chat_users cu ON c.id = cu.chat_id AND cu.chat_type = 'chat' WHERE cu.user_id = ? UNION SELECT g.id, g.unique_code, 'group' as type, g.name FROM groups g JOIN chat_users cu ON g.id = cu.chat_id AND cu.chat_type = 'group' WHERE cu.user_id = ? "); 
$stmt->execute([$user_id, $user_id]); 
$chats = $stmt->fetchAll(); 

// Выбранный чат (если передан chat_id) 
$selected_chat = null; 
$messages = []; 
if (isset($_GET['chat_id'])) { $chat_id = $_GET['chat_id']; 
$stmt = $pdo->prepare("SELECT * FROM messages WHERE chat_id = ? ORDER BY created_at"); 
$stmt->execute([$chat_id]); 
$messages = $stmt->fetchAll(); 
$stmt = $pdo->prepare("SELECT * FROM chats WHERE id = ?"); 
$stmt->execute([$chat_id]); 
$selected_chat = $stmt->fetch(); 

if (!$selected_chat) { $stmt = $pdo->prepare("SELECT * FROM groups WHERE id = ?"); 
$stmt->execute([$chat_id]); 
$selected_chat = $stmt->fetch(); } } 

?> 

<!DOCTYPE html> <html> <head> <title>Chat Widget</title> <style> #chat-widget { width: 300px; height: 400px; border: 1px solid #ccc; display: flex; flex-direction: column; } #messages { flex: 1; overflow-y: scroll; } #message-form { display: flex; } #message-text { flex: 1; } 
	</style> <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> 
	</head> 
		<body> 
			<div id="chat-widget"> <h3>Chat</h3> 
				<div id="messages"> 
				<?php 
					if ($selected_chat): 
				?> 
				

<?php 
	foreach ($messages as $message): 
?> 

<p><strong><?= $message['user_id'] == $user_id ? 'You' : 'User' ?>:</strong> <?= htmlspecialchars($message['message_text']) ?></p> 

<?php 
endforeach; 
?> 

<?php 
else: 
?> 

<p>Select a chat</p> 

<?php 
endif; 
?> </div> 

<?php 
if ($selected_chat): 
?> 

<form id="message-form"> <input type="hidden" id="chat_id" value="<?= $selected_chat['id'] ?>"> 
<input type="text" id="message-text" placeholder="Type your message"> 
<button type="submit">Send</button> </form> 
<?php 
endif; 
?> 

</div>

<script>
      var ws = new WebSocket('ws://<?= WS_HOST ?>:<?= WS_PORT ?>');
      var user_id = <?= $user_id ?>;

      ws.onopen = function() {
          console.log('Connected to WebSocket');
          <?php if ($selected_chat): ?>
              ws.send(JSON.stringify({
                  type: 'subscribe',
                  chat_id: <?= $selected_chat['id'] ?>,
                  user_id: user_id
              }));
          <?php endif; ?>
      };

      ws.onmessage = function(event) {
          var data = JSON.parse(event.data);
          if (data.type == 'message') {
              $('#messages').append('<p><strong>' + (data.user_id == user_id ? 'You' : 'User') + ':</strong> ' + data.message + '</p>');
              $('#messages').scrollTop($('#messages')[0].scrollHeight);
          }
      };

      $('#message-form').submit(function(e) {
          e.preventDefault();
          var message = $('#message-text').val();
          var chat_id = $('#chat_id').val();
          if (message.trim() == '') return;

          ws.send(JSON.stringify({
              type: 'message',
              chat_id: chat_id,
              user_id: user_id,
              message: message
          }));

          $('#message-text').val('');
      });
  </script>
</body> </html>
