<?php
require_once '../inc/config.php';
require_once '../inc/auth.php';
require_once '../inc/db.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: ../auth/login.php');
    exit;
}

$user_id = $_SESSION['user_id'];
$db = new Database();
$user = $db->getUserById($user_id);
$chats = $db->getUserChats($user_id);
$groups = $db->getUserGroups($user_id);
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= APP_NAME ?> - Чат</title>
    <link rel="stylesheet" href="../assets/css/chat.css">
</head>
<body>
    <div class="chat-container">
        <div class="sidebar">
            <div class="user-info">
                <img src="<?= $user['avatar'] ?: '../assets/img/default-avatar.png' ?>" alt="Avatar">
                <span><?= htmlspecialchars($user['name']) ?></span>
            </div>
            
            <div class="search-container">
                <input type="text" id="searchInput" placeholder="Поиск по чатам...">
            </div>
            
            <div class="chat-list">
                <h3>Чаты</h3>
                <?php foreach ($chats as $chat): ?>
                    <div class="chat-item" data-chat-id="<?= $chat['id'] ?>" data-type="chat">
                        <img src="<?= $chat['avatar'] ?: '../assets/img/default-avatar.png' ?>" alt="Chat">
                        <div class="chat-info">
                            <span class="chat-name"><?= htmlspecialchars($chat['name']) ?></span>
                            <span class="last-message"><?= htmlspecialchars($chat['last_message'] ?? '') ?></span>
                        </div>
                    </div>
                <?php endforeach; ?>
                
                <h3>Группы</h3>
                <?php foreach ($groups as $group): ?>
                    <div class="chat-item" data-chat-id="<?= $group['id'] ?>" data-type="group">
                        <img src="<?= $group['avatar'] ?: '../assets/img/default-group.png' ?>" alt="Group">
                        <div class="chat-info">
                            <span class="chat-name"><?= htmlspecialchars($group['name']) ?></span>
                            <span class="last-message"><?= htmlspecialchars($group['last_message'] ?? '') ?></span>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        
        <div class="chat-area">
            <div class="chat-header">
                <span>Выберите чат для начала общения</span>
            </div>
            <div class="messages-container" id="messagesContainer">
                <!-- Сообщения будут загружаться здесь -->
            </div>
            <div class="message-input-container">
                <textarea id="messageInput" placeholder="Введите сообщение..."></textarea>
                <button id="sendButton">Отправить</button>
                <input type="file" id="fileInput" style="display: none;">
                <button id="attachButton">📎</button>
            </div>
        </div>
    </div>

    <script src="../assets/js/websocket.js"></script>
    <script src="../assets/js/chat.js"></script>
</body>
</html>