<?php 

session_start(); 

if (!isset($_SESSION['user_id'])) 
	{ header('Location: index.php'); 
	exit; } 
	
require_once '../inc/db.php'; 
$db = new DB(); 
$pdo = $db->getConnection(); 
$user_id = $_SESSION['user_id']; 
$user_name = $_SESSION['user_name']; 

// Получаем чаты и группы пользователя 
$stmt = $pdo->prepare(" SELECT c.id, c.unique_code, 'chat' as type, NULL as name FROM chats c JOIN chat_users cu ON c.id = cu.chat_id AND cu.chat_type = 'chat' WHERE cu.user_id = ? UNION SELECT g.id, g.unique_code, 'group' as type, g.name FROM groups g JOIN chat_users cu ON g.id = cu.chat_id AND cu.chat_type = 'group' WHERE cu.user_id = ? "); 
$stmt->execute([$user_id, $user_id]); $chats = $stmt->fetchAll(); 

// Если выбран чат, получаем сообщения 
$selected_chat = null; 
$messages = []; if (isset($_GET['chat_id'])) { $chat_id = $_GET['chat_id']; 
$stmt = $pdo->prepare("SELECT * FROM messages WHERE chat_id = ? ORDER BY created_at"); 
$stmt->execute([$chat_id]); $messages = $stmt->fetchAll(); 

// Информация о чате 
$stmt = $pdo->prepare("SELECT * FROM chats WHERE id = ?"); 
$stmt->execute([$chat_id]); 
$selected_chat = $stmt->fetch(); 

if (!$selected_chat) { 
// Может быть, это группа? 
	$stmt = $pdo->prepare("SELECT * FROM groups WHERE id = ?"); 
	$stmt->execute([$chat_id]); $selected_chat = $stmt->fetch(); } } 
	
?> 

<!DOCTYPE html> <html> <head> <title>Chat</title> <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> </head> <body> <h1>Welcome, <?= $user_name ?></h1>
<div style="display: flex;">
      <div style="width: 30%;">
          <h2>Chats</h2>
          <ul>
              <?php foreach ($chats as $chat): ?>
                  <li>
                      <a href="?chat_id=<?= $chat['id'] ?>">
                          <?= $chat['type'] == 'group' ? $chat['name'] : 'Chat ' . $chat['unique_code'] ?>
                      </a>
                  </li>
              <?php endforeach; ?>
          </ul>
      </div>

      <div style="width: 70%;">
          <?php if ($selected_chat): ?>
              <h2>Chat: <?= $selected_chat['name'] ?? $selected_chat['unique_code'] ?></h2>
              <div id="messages" style="height: 400px; overflow-y: scroll;">
                  <?php foreach ($messages as $message): ?>
                      <p><strong><?= $message['user_id'] == $user_id ? 'You' : 'User' ?>:</strong> <?= htmlspecialchars($message['message_text']) ?></p>
                  <?php endforeach; ?>
              </div>
              <form id="message-form">
                  <input type="hidden" id="chat_id" value="<?= $selected_chat['id'] ?>">
                  <input type="text" id="message-text" placeholder="Type your message">
                  <button type="submit">Send</button>
              </form>
          <?php else: ?>
              <p>Select a chat to start messaging.</p>
          <?php endif; ?>
      </div>
  </div>

  <script>
      // WebSocket соединение
      var ws = new WebSocket('ws://<?= WS_HOST ?>:<?= WS_PORT ?>');

      ws.onopen = function() {
          console.log('Connected to WebSocket');
          // Подписываемся на выбранный чат
          <?php if ($selected_chat): ?>
              ws.send(JSON.stringify({
                  type: 'subscribe',
                  chat_id: <?= $selected_chat['id'] ?>,
                  user_id: <?= $user_id ?>
              }));
          <?php endif; ?>
      };

      ws.onmessage = function(event) {
          var data = JSON.parse(event.data);
          if (data.type == 'message') {
              $('#messages').append('<p><strong>' + (data.user_id == <?= $user_id ?> ? 'You' : 'User') + ':</strong> ' + data.message + '</p>');
              // Прокрутка вниз
              $('#messages').scrollTop($('#messages')[0].scrollHeight);
          }
      };

      $('#message-form').submit(function(e) {
          e.preventDefault();
          var message = $('#message-text').val();
          var chat_id = $('#chat_id').val();
          if (message.trim() == '') return;

          // Отправка через WebSocket
          ws.send(JSON.stringify({
              type: 'message',
              chat_id: chat_id,
              user_id: <?= $user_id ?>,
              message: message
          }));

          // Очистка поля
          $('#message-text').val('');
      });
  </script>
  
  </body> </html>
  