<?php
require_once '../inc/config.php';
require_once '../inc/auth.php';
require_once '../inc/db.php';

// Проверка прав администратора
if (!isset($_SESSION['user_id']) || !$_SESSION['is_admin']) {
    header('Location: ../auth/login.php');
    exit;
}

$db = new Database();
$stats = $db->getAdminStats();
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <title>Админ-панель - <?= APP_NAME ?></title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="admin-container">
        <header class="admin-header">
            <h1>Админ-панель</h1>
            <nav>
                <a href="users.php">Пользователи</a>
                <a href="chats.php">Чаты</a>
                <a href="groups.php">Группы</a>
                <a href="../auth/logout.php">Выйти</a>
            </nav>
        </header>

        <div class="stats-grid">
            <div class="stat-card">
                <h3>Пользователи</h3>
                <span class="stat-number"><?= $stats['total_users'] ?></span>
            </div>
            <div class="stat-card">
                <h3>Чаты</h3>
                <span class="stat-number"><?= $stats['total_chats'] ?></span>
            </div>
            <div class="stat-card">
                <h3>Группы</h3>
                <span class="stat-number"><?= $stats['total_groups'] ?></span>
            </div>
            <div class="stat-card">
                <h3>Сообщения</h3>
                <span class="stat-number"><?= $stats['total_messages'] ?></span>
            </div>
        </div>

        <div class="recent-activity">
            <h2>Последняя активность</h2>
            <table>
                <thead>
                    <tr>
                        <th>Пользователь</th>
                        <th>Действие</th>
                        <th>Время</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($db->getRecentActivity() as $activity): ?>
                    <tr>
                        <td><?= htmlspecialchars($activity['user_name']) ?></td>
                        <td><?= htmlspecialchars($activity['action']) ?></td>
                        <td><?= $activity['created_at'] ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>