// chat-widget.js - обновленная версия
class ChatWidget {
    constructor(chatCode, options = {}) {
        this.chatCode = chatCode;
        this.baseUrl = options.baseUrl || '';
        this.chatId = null;
        this.socket = null;
        
        this.createWidget();
        this.setupFileUpload();
    }
    
    createWidget() {
        const widget = document.createElement('div');
        widget.id = 'chatWidget';
        widget.innerHTML = `
            <div class="chat-widget-container">
                <div class="chat-widget-header">
                    <span>Чат поддержки</span>
                    <button class="chat-widget-close">×</button>
                </div>
                <div class="chat-widget-messages" id="widgetMessages"></div>
                <div class="chat-widget-file-upload" id="widgetFileUpload">
                    <input type="file" id="widgetFileInput" multiple style="display: none;">
                    <div class="file-drop-area" id="widgetDropArea">
                        Перетащите файлы сюда
                    </div>
                </div>
                <div class="chat-widget-input">
                    <input type="text" id="widgetInput" placeholder="Введите сообщение...">
                    <button id="widgetAttach">📎</button>
                    <button id="widgetSend">→</button>
                </div>
            </div>
        `;
        
        // Добавление стилей
        const style = document.createElement('style');
        style.textContent = `
            #chatWidget {
                position: fixed;
                bottom: 20px;
                right: 20px;
                width: 350px;
                height: 500px;
                z-index: 9999;
                font-family: Arial, sans-serif;
            }
            
            .chat-widget-container {
                background: white;
                border-radius: 10px;
                box-shadow: 0 4px 20px rgba(0,0,0,0.15);
                display: flex;
                flex-direction: column;
                height: 100%;
            }
            
            .file-drop-area {
                border: 2px dashed #ccc;
                border-radius: 5px;
                padding: 10px;
                text-align: center;
                font-size: 12px;
                color: #666;
                margin: 5px;
                display: none;
            }
            
            .file-drop-area.show {
                display: block;
            }
            
            .file-drop-area.dragover {
                border-color: #007bff;
                background-color: #f8f9fa;
            }
        `;
        
        document.head.appendChild(style);
        document.body.appendChild(widget);
        
        this.setupEventListeners();
        this.connectToChat();
    }
    
    setupFileUpload() {
        const fileInput = document.getElementById('widgetFileInput');
        const attachButton = document.getElementById('widgetAttach');
        const dropArea = document.getElementById('widgetDropArea');
        
        attachButton.addEventListener('click', () => {
            fileInput.click();
        });
        
        fileInput.addEventListener('change', (e) => {
            this.handleFileUpload(e.target.files);
        });
        
        // Drag & Drop
        document.addEventListener('dragenter', (e) => {
            e.preventDefault();
            dropArea.classList.add('show');
        });
        
        document.addEventListener('dragleave', (e) => {
            if (!e.relatedTarget) {
                dropArea.classList.remove('show');
            }
        });
        
        dropArea.addEventListener('dragover', (e) => {
            e.preventDefault();
            dropArea.classList.add('dragover');
        });
        
        dropArea.addEventListener('dragleave', () => {
            dropArea.classList.remove('dragover');
        });
        
        dropArea.addEventListener('drop', (e) => {
            e.preventDefault();
            dropArea.classList.remove('show', 'dragover');
            this.handleFileUpload(e.dataTransfer.files);
        });
    }
    
    handleFileUpload(files) {
        Array.from(files).forEach(file => {
            this.uploadFile(file);
        });
    }
    
    uploadFile(file) {
        if (file.size > 50 * 1024 * 1024) {
            alert('Файл слишком большой (максимум 50MB)');
            return;
        }
        
        const formData = new FormData();
        formData.append('file', file);
        formData.append('chatId', this.chatId);
        
        fetch(`${this.baseUrl}/api/upload_file.php`, {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (!data.success) {
                alert('Ошибка загрузки: ' + data.error);
            }
        })
        .catch(error => {
            alert('Ошибка загрузки файла');
        });
    }
}