<?php
// api/send_message.php
require_once '../config/config.php';
require_once '../config/database.php';
require_once '../classes/Message.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Не авторизован']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$database = new Database();
$message = new Message($database);

$result = $message->sendMessage(
    $input['chatId'], 
    $_SESSION['user_id'], 
    $input['message']
);

echo json_encode(['success' => $result !== false, 'messageId' => $result]);

// api/join_chat.php
require_once '../config/config.php';
require_once '../config/database.php';
require_once '../classes/Chat.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Не авторизован']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$database = new Database();
$chat = new Chat($database);

$result = $chat->joinChatByCode($input['code'], $_SESSION['user_id']);

echo json_encode(['success' => $result]);

// api/search.php
require_once '../config/config.php';
require_once '../config/database.php';
require_once '../classes/Chat.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Не авторизован']);
    exit;
}

$query = $_GET['q'] ?? '';
$database = new Database();
$chat = new Chat($database);

$results = $chat->searchMessages($_SESSION['user_id'], $query);

echo json_encode($results);
?>