<?php
// api/download_file.php
require_once '../config/database.php';
session_start();

if (!isset($_SESSION['user_id']) || !isset($_GET['id'])) {
    http_response_code(403);
    exit('Access denied');
}

$fileId = $_GET['id'];
$userId = $_SESSION['user_id'];

// Проверка прав доступа к файлу
$stmt = $pdo->prepare("
    SELECT f.*, m.chat_id 
    FROM files f
    LEFT JOIN messages m ON f.id = m.file_id
    WHERE f.id = ?
");
$stmt->execute([$fileId]);
$file = $stmt->fetch();

if (!$file) {
    http_response_code(404);
    exit('File not found');
}

// Проверка доступа к чату
if ($file['chat_id']) {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM chat_members WHERE chat_id = ? AND user_id = ?");
    $stmt->execute([$file['chat_id'], $userId]);
    if ($stmt->fetchColumn() == 0) {
        http_response_code(403);
        exit('Access denied');
    }
}

$filePath = '../uploads/' . $file['stored_name'];
if (!file_exists($filePath)) {
    http_response_code(404);
    exit('File not found');
}

// Отправка файла
header('Content-Type: ' . $file['mime_type']);
header('Content-Disposition: attachment; filename="' . $file['original_name'] . '"');
header('Content-Length: ' . filesize($filePath));

readfile($filePath);
?>