<?php
// admin/index.php
require_once '../config/config.php';
require_once '../config/database.php';
require_once '../classes/Chat.php';

if (!isset($_SESSION['user_id']) || !$_SESSION['is_admin']) {
    header('Location: ../login.php');
    exit;
}

$database = new Database();
$chat = new Chat($database);

if ($_POST['action'] ?? '' === 'create_chat') {
    $result = $chat->createChat(
        $_POST['name'],
        $_POST['type'],
        $_POST['description'],
        $_SESSION['user_id']
    );
    $success = "Чат создан! Код: " . $result['code'];
}
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <title>Админ панель - Управление чатами</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-4">
        <h2>Админ панель</h2>
        
        <?php if (isset($success)): ?>
            <div class="alert alert-success"><?= $success ?></div>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5>Создать новый чат</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST">
                            <input type="hidden" name="action" value="create_chat">
                            <div class="mb-3">
                                <label class="form-label">Название чата</label>
                                <input type="text" class="form-control" name="name" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Тип чата</label>
                                <select class="form-control" name="type">
                                    <option value="group">Группа</option>
                                    <option value="private">Личный чат</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Описание</label>
                                <textarea class="form-control" name="description" rows="3"></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary">Создать чат</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>